% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example.R
\docType{data}
\name{exampleDesign}
\alias{exampleDesign}
\alias{exampleCTSSs}
\alias{exampleUnidirectional}
\alias{exampleBidirectional}
\alias{exampleGenes}
\title{Example CAGE Data}
\format{
Example data from various stages of CAGEfightR: \describe{
  \item{exampleDesign}{DataFrame: Description of samples, including .bw
  filenames} \item{exampleCTSS}{RangedSummarizedExperiment: CTSSs}
  \item{exampleUnidirectional}{RangedSummarizedExperiment: Unidirectional or
  Tag Clusters}
  \item{exampleBidirectionalCluster}{RangedSummarizedExperiment:
  Bidirectional clusters} \item{exampleGenes}{RangedSummarizedExperiment:
  Genes} }

An object of class \code{RangedSummarizedExperiment} with 41256 rows and 3 columns.

An object of class \code{RangedSummarizedExperiment} with 21008 rows and 3 columns.

An object of class \code{RangedSummarizedExperiment} with 377 rows and 3 columns.

An object of class \code{RangedSummarizedExperiment} with 127 rows and 3 columns.
}
\source{
\url{http://pubs.acs.org/doi/abs/10.1021/acsnano.6b07533}
}
\usage{
exampleDesign

exampleCTSSs

exampleUnidirectional

exampleBidirectional

exampleGenes
}
\description{
Subset of the CAGE dataset from the paper 'Identification of Gene
Transcription Start Sites and Enhancers Responding to Pulmonary Carbon
Nanotube Exposure in Vivo'. CTSS data from subsets of chr18 and chr19 across
3 mouse (mm9 ) samples are included. Datasets can be loaded with the data
function.
}
\examples{
data(exampleDesign)
data(exampleCTSSs)
data(exampleUnidirectional)
data(exampleBidirectional)
data(exampleGenes)
}
\keyword{datasets}
