% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.R
\name{calcPooled}
\alias{calcPooled}
\title{Calculate pooled expression across all samples.}
\usage{
calcPooled(object, inputAssay = "TPM", outputColumn = "score")
}
\arguments{
\item{object}{RangedSummarizedExperiment: CAGE data quantified at CTSS,
cluster or gene-level.}

\item{inputAssay}{character: Name of assay holding input expression values.}

\item{outputColumn}{character: Name of column in rowRanges to hold pooled
expression.}
}
\value{
object with pooled expression added as a column
  in rowRanges.
}
\description{
Sum expression of features across all samples to obtain a 'pooled' signal.
}
\examples{
data(exampleCTSSs)

# Calculate TPM using supplied total number of tags:
exampleCTSSs <- calcTPM(exampleCTSSs, totalTags='totalTags')

# Sum TPM values over samples:
calcPooled(exampleCTSSs)
}
\seealso{
Other Calculation functions: 
\code{\link{calcBidirectionality}()},
\code{\link{calcComposition}()},
\code{\link{calcShape}()},
\code{\link{calcSupport}()},
\code{\link{calcTPM}()},
\code{\link{calcTotalTags}()},
\code{\link{subsetByBidirectionality}()},
\code{\link{subsetByComposition}()},
\code{\link{subsetBySupport}()}
}
\concept{Calculation functions}
