% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{scoreSignatures}
\alias{scoreSignatures}
\title{Generic gene signature scoring}
\usage{
scoreSignatures(ds, ref.signatures, robust = FALSE)
}
\arguments{
\item{ds}{A BSRDataModel object.}

\item{ref.signatures}{Gene signatures.}

\item{robust}{A logical indicating that z-scores
should be computed with median and MAD
instead of mean and standard deviation.}
}
\value{
A matrix containing the scores of
each gene signature in each sample.
Note that ligand-receptor gene
signature scores should be computed with
\code{"\link[=BSRDataModel-class]{scoreLRGeneSignatures}"}
instead.
}
\description{
Scores generic gene signatures over the
samples of a BSRDataModel object.
}
\details{
This function relies on
a simple average of gene z-scores over each signature.
It is no replacement for mode advanced methods
such as CIBERSORT or BisqueRNA.
It is provided for convenience.
}
\examples{
data(sdc, package = "BulkSignalR")
data(bsrdm, package = "BulkSignalR")

data(immune.signatures, package = "BulkSignalR")
imm.scores <- scoreSignatures(bsrdm, immune.signatures)
}
