% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSRInference-class.R
\name{getPathwayStats}
\alias{getPathwayStats}
\alias{getPathwayStats,BSRInference-method}
\title{Basic statistics about hit pathways}
\usage{
\S4method{getPathwayStats}{BSRInference}(obj, pval.thres = NULL, qval.thres = NULL)
}
\arguments{
\item{obj}{BSRinf object.}

\item{pval.thres}{P-value threshold.}

\item{qval.thres}{Q-value threshold.}
}
\value{
A table with the pathways selected after the chosen threshold was
  applied to rows in \code{LRinter(obj)}.
Each pathway is reported along with various statistics:
the number of selected receptors in this pathway, the total number of
receptors described this pathway,
the number of selected ligand-receptor pairs hitting this pathway,
and the total number of
ligand-receptor pairs described that could hit this pathway.

Obviously, one could imagine computing enrichment in receptors or
ligand-receptor pairs
based on such statistics, but the actual meaning of such an analysis
would be ambiguous since
the pathways were already selected as significantly regulated by the
receptor. We thus did not implement
this (hypergeometric test) computation.
}
\description{
Basic statistics about hit pathways
}
\examples{
data(bsrinf, package = "BulkSignalR")

pw.stat <- getPathwayStats(bsrinf)


}
