% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cellTypeAssign.R
\name{cellularNetworkTable}
\alias{cellularNetworkTable}
\title{Build a table describing a cellular network}
\usage{
cellularNetworkTable(lr, autocrine = FALSE)
}
\arguments{
\item{lr}{The data.frame output by
\code{"\link{assignCellTypesToInteractions}"}.}

\item{autocrine}{A logical indicating whether autocrine interactions should
be included.}
}
\value{
A data.frame containing all the links in the cellular network. A
link is created between two cell types as soon as there was a L-R interaction
that was associated with both cell types. The link is given a score
equal to the geometric mean of each cell type assignment r2.
}
\description{
Generate a data.frame including all the links between cell types
mediated by L-R interactions with their respective weights.
}
\examples{
data(bsrdm, package = "BulkSignalR")
data(bsrinf, package = "BulkSignalR")
data(immune.signatures, package = "BulkSignalR")
data(tme.signatures, package = "BulkSignalR")

immune.signatures <- immune.signatures[immune.signatures$signature \%in\%
    c("T cells"), ]

signatures <- rbind(immune.signatures, tme.signatures[
    tme.signatures$signature \%in\% c("Fibroblasts"),
])

tme.scores <- scoreSignatures(bsrdm, signatures)

# assignment
lr2ct <- assignCellTypesToInteractions(bsrdm, bsrinf, tme.scores)

# cellular network
g.table <- cellularNetworkTable(lr2ct)
}
