% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgBiocDeps.R
\name{pkgBiocDeps}
\alias{pkgBiocDeps}
\title{Look up a package's Bioconductor dependencies}
\usage{
pkgBiocDeps(
  pkg,
  pkgType = c("software", "data-experiment", "workflows", "data-annotation"),
  which = "strong",
  only.bioc = TRUE,
  recursive = FALSE,
  version = BiocManager::version()
)
}
\arguments{
\item{pkg}{\code{character(1)} The package for which to look up dependencies.}

\item{pkgType}{\code{character()} Any of 'software', 'data-experiment',
'workflows', and / or 'data-annotation' (defaults to all)}

\item{which}{a character vector listing the types of
    dependencies, a subset of
    \code{c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances")}.
    Character string \code{"all"} is shorthand for that vector,
    character string \code{"most"} for the same vector without
    \code{"Enhances"},
    character string \code{"strong"} (default) for the first three
    elements of that vector.
  }

\item{only.bioc}{\code{logical(1)} Whether to only return Bioconductor
dependencies in the list (default \code{TRUE})}

\item{recursive}{a logical indicating whether (reverse) dependencies
    of (reverse) dependencies (and so on) should be included, or a
    character vector like \code{which} indicating the type of (reverse)
    dependencies to be added recursively.}

\item{version}{(Optional) \code{character(1)} or \code{package_version}
indicating the \emph{Bioconductor} version (e.g., "3.8") for which
repositories are required.}
}
\description{
The function uses the \code{pkgType} argument to restrict the look up to only the
relevant Bioconductor repository. It works for multiple packages of the same
type.
}
\examples{

pkgBiocDeps("MultiAssayExperiment", only.bioc = TRUE)

pkgBiocDeps("MultiAssayExperiment", only.bioc = FALSE)

}
