% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biocDownloadStats.R
\name{activitySince}
\alias{activitySince}
\title{What are the issues, pulls, commits created since a date?}
\usage{
activitySince(
  gh_repo,
  activity = c("issues", "pulls", "commits"),
  status = c("closed", "open", "all"),
  Date,
  issue_metadata = c("created_at", "number", "title"),
  token = NULL
)
}
\arguments{
\item{gh_repo}{\code{character(1)} The GitHub repository location including the
username / organization and the repository name, e.g.,
"Bioconductor/S4Vectors"}

\item{activity}{\code{character(1)} The type of repository activity to pull from the
GitHub API. It can be one of "issues" (default), "pulls", or "commits".}

\item{status}{\code{character(1)} One of 'closed', 'open', or 'all' corresponding to
the issue state desired from the GitHub API (Default: "closed"). This
argument is ignored for the "commits" activity report.}

\item{Date}{\code{character(1)} The date cutoff from which to analyze closed issues
in the YYYY-MM-DD or YYYY-MM-DDTHH:MM:SSZ format (ISO 8601).}

\item{issue_metadata}{\code{character()} The metadata labels to extract from the
\code{gh::gh} response. See \code{?gh::gh} for more details. Defaults to
'created_at', 'number', and 'title'. This argument is ignored for the
"commits" activity report.}

\item{token}{\code{character(1)} For big requests, e.g., commit history, you may be
prompted to use a GitHub Personal Access Token. Enter the token as plain
text.}
}
\value{
A \code{tibble} with three columns corresponding to issue metadata (i.e.,
"created_at", "number", "title")
}
\description{
This function uses the \code{gh} package to get a list of either issues, pull
requests, or GitHub commits since the specified date for a particular GitHub
repository. The repository must have both the username / organization and the
name, e.g., "Bioconductor/S4Vectors".
}
\details{
The \code{tibble} returned by the commits activity report contains five
columns:
\itemize{
\item 'committer_date'
\item 'commit' - hash
\item 'parents' - hash of parent for merge commits
\item 'author'
\item 'message'
}

For information on other columns, refer to the GitHub API under repository
issues or pulls (e.g., \verb{/repos/:repo/issues}).
}
\examples{
if (interactive()) {

  activitySince("Bioconductor/S4Vectors", "issues", "closed", "2021-05-01")
  activitySince("Bioconductor/S4Vectors", "issues", "open", "2022-05-01")
  activitySince("Bioconductor/S4Vectors", "commits", Date = "2022-05-01")

}

}
