% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CRANstatus.R
\name{CRANstatus}
\alias{CRANstatus}
\title{Check the CRAN build report page and email a notification}
\usage{
CRANstatus(
  pkg,
  core.name = NULL,
  core.email = NULL,
  core.id = NULL,
  to.mail = "maintainer@bioconductor.org",
  dry.run = TRUE,
  emailTemplate = templatePath("cranreport")
)
}
\arguments{
\item{pkg}{\code{character(1)} The name of the package in trouble}

\item{core.name}{\code{character(1)} The full name of the core team member}

\item{core.email}{\code{character(1)} The Roswell Park email of the core team
member}

\item{core.id}{\code{character(1)} The internal identifier for the Roswell employee.
This ID usually matches \verb{^[A-Z]\{2\}[0-9]\{5\}} for more recent identifiers.}

\item{to.mail}{The email of the CRAN report recipient}

\item{dry.run}{\code{logical(1)} Display the email without sending to the recipient.
It only works for HTML email reports and ignored when \code{textOnly=TRUE}}

\item{emailTemplate}{\code{character(1)} The path to the email template Rmd file as
obtained by \code{templatePath()}. A custom template can be provided as file
path.}
}
\description{
The \code{CRANstatus} function allows users to check the status of a package
and send an email report of any failures.
}
