library(shiny)
library(BiocFHIR)
  fns = make_test_json_set()
  zn = gsub(".*jsontest/", "", fns)
  zns = strsplit(zn, "_")
  fn = sapply(zns, "[", 1)
  ln = sapply(zns, "[", 2)
  folks = paste(fn, ln, sep="_")

  names(fns) = folks

oldui = fluidPage(
   sidebarLayout(
    sidebarPanel(
     helpText("FHIR viewer for synthea data subset"),
     selectInput("indiv", "Person", choices=fns), width=2
     ),
    mainPanel(
     tabsetPanel(
      tabPanel("patient",
       DT::dataTableOutput("patient")
       ),
      tabPanel("condition",
       DT::dataTableOutput("condition")
       ),
      tabPanel("encounter",
       DT::dataTableOutput("encounter")
       ),
      tabPanel("observation",
       DT::dataTableOutput("observation")
       ),
      tabPanel("claims",
       DT::dataTableOutput("claims")
       ),
      tabPanel("about",
       helpText("FHIR documents were sampled from those distributed at 
https://synthetichealth.github.io/synthea-sample-data/downloads/synthea_sample_data_fhir_r4_sep2019.zip"),
       helpText("The downloads page includes:

'Data hosted within SyntheticMass has been generated by SyntheaTM, an open-source patient population simulation made available by The MITRE Corporation.

The data is free from cost, privacy, and security restrictions. It can be used without restriction for a variety of secondary uses in academia, research, industry, and government.

Please cite SyntheaTM or SyntheticMass as:

Jason Walonoski, Mark Kramer, Joseph Nichols, Andre Quina, Chris Moesel, Dylan Hall, Carlton Duffett, Kudakwashe Dube, Thomas Gallagher, Scott McLachlan, Synthea: An approach, method, and software mechanism for generating synthetic patients and the synthetic electronic health care record, Journal of the American Medical Informatics Association, Volume 25, Issue 3, March 2018, Pages 230–238, https://doi.org/10.1093/jamia/ocx079'"),
       helpText("Fields retrieved for FHIR concepts are determined by a 'schema' collection."),
       helpText("For some documents, it may be necessary to collect information from a different field
than that specified in these schemas.  For example, a document may use 'patient' or 'subject' to identify
an individual.  A 'fallback' schema usage may be adopted in future versions to cope with this."),
       verbatimTextOutput("schema"),
       verbatimTextOutput("pkgdesc")
       ),
      )
     )
    )
   ) # fluidPage

   oldserver = function(input, output) {
     fdat = reactive({
      process_fhir_bundle(input$indiv)
      })
     output$patient = DT::renderDataTable({
         process_Patient(fdat()$Patient)
         })
     output$observation = DT::renderDataTable({
         process_Observation(fdat()$Observation)
         })
     output$claims = DT::renderDataTable({
         process_Claim(fdat()$Claim)
         })
     output$condition = DT::renderDataTable({
         process_Condition(fdat()$Condition)
         })
     output$encounter = DT::renderDataTable({
         process_Encounter(fdat()$Encounter)
         })
     output$schema = renderPrint({
         BiocFHIR::FHIR_retention_schemas()
         })
     output$pkgdesc = renderPrint({
         packageDescription("BiocFHIR")
         })
     }


#process_CarePlan.R:process_CarePlan = function(CarePlan) {
#process_Claim.R:process_Claim = function(Claim) {
#process_Condition.R:process_Condition = function(Condition) {
#process_Observation.R:process_Observation = function(Observation) {
#processOthers.R:process_Encounter = function(Encounter) {
#processOthers.R:process_AllergyIntolerance = function(AllergyIntolerance) {
#processOthers.R:#process_Observation = function(Observation) {
#processOthers.R:process_MedicationRequest = function(MedicationRequest) {
#processOthers.R:process_Procedure = function(Procedure) {
#processOthers.R:process_Immunization = function(Immunization) {
#process_Patient.R:process_Patient = function(Patient) {
#use_json.R:process_fhir_bundle = function(json_file) {


  ui = fluidPage(
   sidebarLayout(
    sidebarPanel(
     helpText("FHIR viewer for synthea data subset"),
     selectInput("indiv", "Person", choices=fns), 
     actionButton("stopBtn", "stop app"),
     width=2
     ),
    mainPanel(
     tabsetPanel(
      tabPanel("patient",
       DT::dataTableOutput("patient")
       ),
      tabPanel("condition",
       DT::dataTableOutput("condition")
       ),
      tabPanel("encounter",
       DT::dataTableOutput("encounter")
       ),
      tabPanel("Rx",
       DT::dataTableOutput("Rx")
       ),
      tabPanel("observation",
       DT::dataTableOutput("observation")
       ),
      tabPanel("procedure",
       DT::dataTableOutput("procedure")
       ),
      tabPanel("careplan",
       DT::dataTableOutput("careplan")
       ),
      tabPanel("claims",
       DT::dataTableOutput("claims")
       ),
      tabPanel("network",
       helpText("This is a display of relations among patients, conditions, and procedures for 50 synthea bundles"),
       helpText("Use clickwheel to zoom in, click on to drag"),
       visNetwork::visNetworkOutput("network")
       ),
      tabPanel("about",
       helpText("FHIR documents were sampled from those distributed at 
https://synthetichealth.github.io/synthea-sample-data/downloads/synthea_sample_data_fhir_r4_sep2019.zip"),
       helpText("The downloads page includes:

'Data hosted within SyntheticMass has been generated by SyntheaTM, an open-source patient population simulation made available by The MITRE Corporation.

The data is free from cost, privacy, and security restrictions. It can be used without restriction for a variety of secondary uses in academia, research, industry, and government.

Please cite SyntheaTM or SyntheticMass as:

Jason Walonoski, Mark Kramer, Joseph Nichols, Andre Quina, Chris Moesel, Dylan Hall, Carlton Duffett, Kudakwashe Dube, Thomas Gallagher, Scott McLachlan, Synthea: An approach, method, and software mechanism for generating synthetic patients and the synthetic electronic health care record, Journal of the American Medical Informatics Association, Volume 25, Issue 3, March 2018, Pages 230–238, https://doi.org/10.1093/jamia/ocx079'"),
       helpText("Fields retrieved for FHIR concepts are determined by a 'schema' collection."),
       helpText("For some documents, it may be necessary to collect information from a different field
than that specified in these schemas.  For example, a document may use 'patient' or 'subject' to identify
an individual.  A 'fallback' schema usage may be adopted in future versions to cope with this."),
       verbatimTextOutput("schema"),
       verbatimTextOutput("pkgdesc")
       ),
      )
     )
    )
   ) # fluidPage

   server = function(input, output) {
     fdat = reactive({
      process_fhir_bundle(input$indiv)
      })
     output$patient = DT::renderDataTable({
         process_Patient(fdat()$Patient)
         })
     output$observation = DT::renderDataTable({
         process_Observation(fdat()$Observation)
         })
     output$claims = DT::renderDataTable({
         process_Claim(fdat()$Claim)
         })
     output$condition = DT::renderDataTable({
         process_Condition(fdat()$Condition)
         })
     output$encounter = DT::renderDataTable({
         process_Encounter(fdat()$Encounter)
         })
     output$Rx = DT::renderDataTable({
         process_MedicationRequest(fdat()$MedicationRequest)
         })
     output$procedure = DT::renderDataTable({
         process_Procedure(fdat()$Procedure)
         })
     output$careplan = DT::renderDataTable({
         process_CarePlan(fdat()$CarePlan)
         })
     output$network = visNetwork::renderVisNetwork({
         data(allin)
         BiocFHIR::FHIR_retention_schemas()
         g = build_proccond_igraph( allin ) 
         display_proccond_igraph( g )
         })
     output$schema = renderPrint({
         BiocFHIR::FHIR_retention_schemas()
         })
     output$pkgdesc = renderPrint({
         packageDescription("BiocFHIR")
         })
     observeEvent(input$stopBtn, {
       stopApp(returnValue=NULL)   # could return information here
      })

     }



shinyApp(ui=ui, server=server)
