% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc.R, R/check.R, R/editing.R, R/pages.R
\name{BiocBook-editing}
\alias{BiocBook-editing}
\alias{check_deps}
\alias{edit_yml}
\alias{edit_bib}
\alias{edit_requirements_yml}
\alias{edit_css}
\alias{preview}
\alias{publish}
\alias{status}
\alias{add_preamble}
\alias{add_chapter}
\alias{edit_page}
\title{Editing BiocBook accessory files}
\usage{
check_deps(book)

edit_yml(book, yml = c("_book", "_website", "_knitr", "_format"), open = TRUE)

edit_bib(book, open = TRUE)

edit_requirements_yml(book, open = TRUE)

edit_css(book, open = TRUE)

preview(book, browse = FALSE, watch = FALSE)

publish(book, message = "Publishing")

status(book)

add_preamble(book, open = TRUE)

add_chapter(book, title, file = NA, position = NULL, open = TRUE)

edit_page(book, file, open = TRUE)
}
\arguments{
\item{book}{A \code{BiocBook} object, opened with \code{BiocBook} or created by \code{init()}.}

\item{yml}{Which .yml should be opened?}

\item{open}{Optional. Whether to open the file for interactive editing (default: TRUE)}

\item{browse}{Optional. Passed to \code{quarto_preview()} (default: FALSE).}

\item{watch}{Optional. Passed to \code{quarto_preview()} (default: FALSE).}

\item{message}{Optional. Message used when committing with \code{publish()}.}

\item{title}{A character string for a title for the new chatper. If \code{file} is not explicitely provided, the
title should only contain alphanumeric characters and spaces}

\item{file}{Optional. A character string for the name of the \code{.qmd} file to write the new chapter.
The extension \code{.qmd} has to be provided. If not provided,
the file name is deduced from the \code{title} argument.}

\item{position}{Optional. A position to insert the chapter. For example,
if \code{position = 2}, the new chapter will be inserted after the first existing
chapter (i.e. the \code{Welcome} page)}
}
\value{
\itemize{
\item \verb{add_*}, \verb{edit_*}: A \code{BiocBook} object (invisible).
\item \code{publish}: TRUE (invisible) if pushing to Github was successful;
\item \code{preview}: Local URL to browse dynamically rendered book;
\item \code{status}: A tibble of the existing versions found on the Github
repository (branch \code{gh-pages}) and of the existing Dockerfiles.
}
}
\description{
Editing functions for \code{BiocBook}s. See \code{\link{BiocBook}} help
sections for extended description.
}
\section{\verb{add_*} functions}{


\code{add_chapter()} and \code{add_preamble} are convenient functions
to add pages to a \code{BiocBook}.
}

\section{\verb{edit_*} functions}{


Several accessory files can be manually edited:
\itemize{
\item \code{edit_page()}: manually edit any page listed in \code{chapters(book)}
\item \code{edit_bib()}: manually edit \verb{/inst/assets/bibliography.bib}
\item \code{edit_yml()}: manually edit the different \code{yml} in \verb{/inst/assets/}
\item \code{edit_requirements_yml()}: manually edit \verb{/inst/requirements.yml}
}
}

\section{Maintenance functions}{


Extra functions are provided to faciliate the maintenance of \code{BiocBook}s.
\itemize{
\item \code{check_deps()}: is used to find dependencies from chapter pages
that are not listed in DESCRIPTION
\item \code{preview()}: is used to dynamically render the book locally
\item \code{publish()}: is used to commit and push to remote Github branch
\item \code{status()}: is used to list the book versions already
deployed on the Github repository (branch \code{gh-pages}) and of the
existing Dockerfiles
}
}

\examples{
## In practice, you should not use `.local` argument. 
unique_id <- as.numeric(Sys.time())
bookname <- paste(Sys.info()[['sysname']], unique_id, sep = '.')
bb <- init(bookname, .local = TRUE)
add_preamble(bb, open = FALSE)
add_chapter(bb, title = "Chapitre Un", open = FALSE)
unlink(bookname, recursive = TRUE)
}
\seealso{
\code{\link{BiocBook}}
}
