% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BioTIP_update_3.3_02282020.R
\name{simulationMCI}
\alias{simulationMCI}
\title{Get MCI Scores for randomly selected genes}
\usage{
simulationMCI(
  len,
  samplesL,
  df,
  adjust.size = FALSE,
  B = 1000,
  fun = c("cor", "BioTIP")
)
}
\arguments{
\item{len}{An integer that is the length of genes in the CTS (critical transition signal).}

\item{samplesL}{A list of vectors,  whose length is the number of states. Each vector gives the sample names in a state.
Note that the vector s (sample names) has to be among the column names of the R object 'df'.}

\item{df}{A numeric matrix or dataframe of numerics, factor or character.
The rows and columns represent unique transcript IDs (geneID) and sample names,  respectively}

\item{adjust.size}{A boolean value indicating if MCI score should be adjust by module size (the number of transcripts
in the module) or not. Default FALSE.}

\item{B}{An integer, setting the permutation with \code{B} runs. Default is 1000.}

\item{fun}{A character chosen between ("cor", "BioTIP"), indicating where an adjusted
correlation matrix will be used to calculated the MCI score.}
}
\value{
A numeric matrix indicating the MCI scores of permutation.
The dimension (row X column) of this matrix is the length of \code{samplesL} * \code{B}.
}
\description{
This function gets the MCI scores for randomly selected features (e.g. transcript ids),
}
\examples{
counts = matrix(sample(1:100, 18), 3, 9)
colnames(counts) = 1:9
row.names(counts) = c('loci1', 'loci2', 'loci3')
cli = cbind(1:9, rep(c('state1', 'state2', 'state3'), each = 3))
colnames(cli) = c('samples', 'group')
samplesL <- split(cli[, 1], f = cli[, 'group'])
simMCI = simulationMCI(2, samplesL, counts, B=2)
simMCI
#            [,1]      [,2]
#state1  2.924194  2.924194
#state2 20.877138 20.877138
#state3  2.924194  2.924194

}
\author{
Zhezhen Wang \email{zhezhen@uchicago.edu}; Xinan H Yang \email{xyang2@uchicago.edu}
}
