% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leadingEdge.R
\name{getLeadingEdgeIndexFromVector}
\alias{getLeadingEdgeIndexFromVector}
\alias{getLeadingEdgeIndexFromMatrix}
\title{Getting leading-edge indices from a vector}
\usage{
getLeadingEdgeIndexFromVector(
  x,
  index,
  comparison = c("greater", "less"),
  reference = c("background", "geneset")
)

getLeadingEdgeIndexFromMatrix(
  x,
  index,
  comparison = c("greater", "less"),
  reference = c("background", "geneset")
)
}
\arguments{
\item{x}{A numeric vector (\code{getLeadingEdgeIndexFromVector}) or a numeric matrix (\code{getLeadingEdgeIndexFromMatrix}).}

\item{index}{An integer vector, indicating the indices of genes in a gene-set.}

\item{comparison}{Character string, are values greater than or less than the reference value considered as leading-edge? This depends on the type of value requested by the user in \code{wmwTest}.}

\item{reference}{Character string, which reference is used? If \code{background}, genes with expression higher than the median of the background are reported. Otherwise in the case of \code{geneset}, genes with expression higher than the median of the gene-set is reported. Default is \code{background}, which is consistent with the results of the Wilcoxon-Mann-Whitney tests.}
}
\value{
An integer vector, indicating the indices of leading-edge genes.
}
\description{
Getting leading-edge indices from a vector
}
\section{Functions}{
\itemize{
\item \code{getLeadingEdgeIndexFromMatrix}: \code{x} is a \code{matrix}.
}}

\examples{
myProfile <- c(rnorm(5, 3), rnorm(15, -3), rnorm(100, 0))
getLeadingEdgeIndexFromVector(myProfile, 1:20)
getLeadingEdgeIndexFromVector(myProfile, 1:20, comparison="less")
getLeadingEdgeIndexFromVector(myProfile, 1:20, comparison="less", reference="geneset")
myProfile2 <- c(rnorm(15, 3), rnorm(5, -3), rnorm(100, 0))
myProfileMat <- cbind(myProfile, myProfile2)
getLeadingEdgeIndexFromMatrix(myProfileMat, 1:20)
getLeadingEdgeIndexFromMatrix(myProfileMat, 1:20, comparison="less")
getLeadingEdgeIndexFromMatrix(myProfileMat, 1:20, comparison="less", reference="geneset")
}
\seealso{
\code{\link{wmwTest}}
}
