% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllMethods.R
\name{SignedIndexList}
\alias{SignedIndexList}
\alias{SignedIndexList,list-method}
\title{Convert a list into a SignedIndexList}
\usage{
SignedIndexList(object, ...)

\S4method{SignedIndexList}{list}(object, keepNA = FALSE, keepDup = FALSE, offset = 1L)
}
\arguments{
\item{object}{A list of lists, each with two elements named `pos` or `neg`, can be logical vectors or integer indices}

\item{...}{additional arguments, currently ignored}

\item{keepNA}{Logical, whether NA indices should be kept or not. Default: 
FALSE (removed)}

\item{keepDup}{Logical, whether duplicated indices should be kept or not. 
Default: FALSE (removed)}

\item{offset}{offset; 1 if missing}
}
\value{
A SignedIndexList, a list of lists, containing two vectors named `positive` and `negative`, 
which contain the indices of genes that are either positively or negatively associated with a certain
phenotype
}
\description{
Convert a list into a SignedIndexList
}
\examples{
myList <- list(a = list(pos = list(1, 2, 2, 4), neg = c(TRUE, FALSE, TRUE)), 
b = list(NA), c = list(pos = c(c(2, 3), c(1, 3))))
SignedIndexList(myList)

## a special case of input is a single list with two elements, \code{pos} and \code{neg}
SignedIndexList(myList[[1]])
}
