% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcn_inference.R
\name{plot_gene_significance}
\alias{plot_gene_significance}
\title{Plot a heatmap of gene significance}
\usage{
plot_gene_significance(corandp, palette = "RdYlBu", transpose = FALSE, ...)
}
\arguments{
\item{corandp}{A data frame of gene-trait correlations as returned
by \code{gene_significance()}.}

\item{palette}{Character indicating which RColorBrewer palette to use.
Default: 'RdYlBu'.}

\item{transpose}{Logical indicating whether to transpose the heatmap
or not.}

\item{...}{Additional arguments to \code{ComplexHeatmap::pheatmap()}.}
}
\value{
A `Heatmap` object created by \code{ComplexHeatmap::pheatmap()}.
}
\description{
Plot a heatmap of gene significance
}
\details{
Significance levels:
1 asterisk: significant at alpha = 0.05.
2 asterisks: significant at alpha = 0.01.
3 asterisks: significant at alpha = 0.001.
no asterisk: not significant.
}
\examples{
data(filt.se)
gcn <- exp2gcn(filt.se, SFTpower = 18, cor_method = "pearson")
corandp <- gene_significance(filt.se)
plot_gene_significance(corandp, show_rownames = FALSE)
}
