% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotateNetwork.R
\name{annotateGoCC}
\alias{annotateGoCC}
\title{Add GO CC  annotation to the graph vertices}
\usage{
annotateGoCC(gg, annoF, idatt = "name")
}
\arguments{
\item{gg}{graph to update}

\item{annoF}{annotation matrix in Pair form}

\item{idatt}{optional name of the vertex attribute to map to the
annotation \code{data.frame} first column}
}
\value{
annotated igraph object
}
\description{
The function loads an annotation data matrix called \code{annoF}, which
contains three columns; the first containing gene Entrez IDs, the second
gene GO ID terms, the third gene GO CC description terms. The function
then performs a many-to-one mapping of each matrix row to a network vertex
using matching Entrez IDs, filling the vertices attributes \code{GO_CC_ID}
and  \code{GO_CC}.
}
\examples{
file <- system.file("extdata", "PPI_Presynaptic.gml", package = "BioNAR")
gg <- igraph::read_graph(file, format="gml")
sfile<-system.file("extdata", "flatfile.go.CC.csv", package = "BioNAR")
goCC <- read.table(sfile, sep="\t", skip=1, header=FALSE,
strip.white=TRUE, quote="")
sgg <- annotateGoCC(gg, goCC)
}
\seealso{
getAnnotationVertexList
}
