% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamo.R
\name{metlMatrix}
\alias{metlMatrix}
\title{Convert sparce matrix into triplet \code{data.frame}.}
\usage{
metlMatrix(sparceM)
}
\arguments{
\item{sparceM}{sparce matrix to convert into triplet \code{data.frame}}
}
\value{
\code{data.frame} with three colums:
\itemize{
\item i -- row index;
\item j -- column index;
\item x -- cell value;
\item Rname -- i-th row name;
\item Cname -- j-th column name.
}
}
\description{
For very large graphs handling adjacency-like matrices is difficult due to
its sparse nature. This function convert sparse matrix into triplet
\code{data.frame} with row and column indices and names, and cell value.
}
\examples{
data(karate, package='igraphdata')
upgrade_graph(karate)
Ws <- as_adjacency_matrix(karate,type='both',attr='weight',sparse = TRUE)
mdf<-metlMatrix(Ws)
head(mdf)
}
