% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bowTie.R
\name{markBowTie}
\alias{markBowTie}
\title{Calculates bow-tie decomposition and marks vertices with one of the
following in the \code{BowTie} attribute:
\itemize{
\item SCC -- maximal strong connected component;
\item IN -- vertices not in SCC, but SCC is reachable from them;
\item OUT -- vertices not in SCC, but reachable from SCC;
\item TU -- vertices not in all three above, but reachable from IN and
OUT is reachable from them (TUBES);
\item IDR -- vertices not in SCC, but they are reachable from IN and
OUT is NOT reachable from them (INTENDRILS);
\item ODR -- vertices not is SCC, but they are NOT reachable from IN and
OUT is reachable from them (OUTTENDRILS);
\item OTR -- all other vertices.
}}
\usage{
markBowTie(g)
}
\arguments{
\item{g}{graph to analyse}
}
\value{
graph with \code{BowTie} vertex attribute
}
\description{
Algorithm proposed in:
}
\details{
"Bow-tie Decomposition in Directed Graphs" - Yang et al. IEEE (2011)
}
