% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{makeMembership}
\alias{makeMembership}
\title{Create membership \code{data.frame} from graph for arbitrary annotation}
\usage{
makeMembership(gg, membership)
}
\arguments{
\item{gg}{igraph object to assign membership}

\item{membership}{either name of the vertex attribute or vector of membership}
}
\value{
\code{data.frame} with two columns \code{names} and \code{membership}
}
\description{
Create membership \code{data.frame} from graph vertex attribute or vector
of cluster names, IDs or indices. This function is simular to
\code{\link{calcMembership}} but do not linked to clustering algorithm.
}
\details{
Any annotation coercible to \code{factor} could be converted to the
membership \code{data.frame}. This function is useful, for example, to
make layout with \code{\link{layoutByCluster}}.
}
\examples{
karate <- make_graph("Zachary")
# We need vertex ID in the 'name' attribute of the vertex
V(karate)$name<-c(LETTERS,letters)[1:vcount(karate)]
m<-makeMembership(karate,rep(c(1,2),length.out=vcount(karate)))
head(m)
}
