% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runCentrality.R
\name{getGraphCentralityECDF}
\alias{getGraphCentralityECDF}
\title{Convert centrality matrix into ECDF}
\usage{
getGraphCentralityECDF(m)
}
\arguments{
\item{m}{centrality matrix from \code{\link{getCentralityMatrix}}
invocation.}
}
\value{
list of several ecdf objects, corresponding to values in
centrality matrix from \code{\link{getCentralityMatrix}} invocation.
}
\description{
Convert centrality matrix into ECDF
}
\examples{
file <- system.file("extdata", "PPI_Presynaptic.csv", package = "BioNAR")
tbl <- read.csv(file, sep="\t")
gg <- buildNetwork(tbl)
m<-getCentralityMatrix(gg)
ecdfL<-getGraphCentralityECDF(m)
}
\seealso{
getCentralityMatrix
}
