% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{diseasome}
\alias{diseasome}
\title{Barabasi's Diseasome Network}
\format{
A bipartite graph as \code{\link[igraph]{graph}} object.

Vertex attributes: \sQuote{name} for the node ID, \sQuote{Name} for the
human readable node name, \sQuote{Disorder.class},
\sQuote{Type} for the human readable node type,
\sQuote{label} and \sQuote{shape} for plotting the graph,
\sQuote{type} the node type for bipartite \code{\link[igraph]{graph}}
representation.
}
\source{
Goh, K.-I. et al. The human disease network. Proc. Natl. Acad. Sci.
U.S.A. 104, 8685–8690 (2007).
https://pnas.org/doi/full/10.1073/pnas.0701361104
}
\usage{
diseasome
}
\description{
In the paper Goh.t al. (2007) doi:10.1073/pnas.0701361104 Barabasi with
colleagues published Diseasome: a network of disorders and disease genes
linked by known disorder–gene associations. We extract definition of the
genes, disorders and interactions from papers supplementary materials and
store it as \code{\link[igraph]{graph}} object.
}
\details{
Diseasesome is a bipartite graph that have nodes of two types \code{gene}
and \code{disease} and links are allowed only between nodes of different
types. It could be projected to Human Disease Network (HDN) and Disease
Gene Network (DGN).
}
\keyword{diseasome}
\keyword{graphs}
