% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runCentrality.R
\name{calcCentralityExternalDistances}
\alias{calcCentralityExternalDistances}
\title{Function to calculate a distance matrix between a list of permuted vertex
centrality matrices and a unperturbed reference matrix.}
\usage{
calcCentralityExternalDistances(m, l, keepOrder = FALSE, dist = "euclidean")
}
\arguments{
\item{m}{reference matrix, for example centrality obtained by invocation
\code{\link{getCentralityMatrix}}}

\item{l}{list of permuted matrix, for example centrality obtained by
invocation \code{\link{getRandomGraphCentrality}}}

\item{keepOrder}{if FALSE valuess will be sorted}

\item{dist}{methods available from dist function}
}
\value{
matrix with seven columns  containing distances between each element
of \code{l} and reference matrix \code{m}
}
\description{
Function to calculate a distance matrix between a list of permuted vertex
centrality matrices and a unperturbed reference matrix.
}
\examples{
data(karate,package='igraphdata')
m<-getCentralityMatrix(karate)
gnp<-list()
for(i in 1:10){
    gnp[[i]]<-getRandomGraphCentrality(karate,type = 'gnp')
}
gnpEDist<-calcCentralityExternalDistances(m,gnp)
summary(gnpEDist)
}
\seealso{
getRandomGraphCentrality

getCentralityMatrix

calcCentralityInternalDistances
}
