% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotateNetwork.R
\name{annotateTopOntoOVG}
\alias{annotateTopOntoOVG}
\title{Annotate graph with disease terms}
\usage{
annotateTopOntoOVG(gg, dis, idatt = "name")
}
\arguments{
\item{gg}{igraph object to annotate}

\item{dis}{annotation matrix in Pairs form}

\item{idatt}{optional name of the vertex attributes that contains Entrez IDs}
}
\value{
annotated igraph object
}
\description{
The function loads a human disease annotation matrix called \code{dis}, which
contains three columns; the first containing gene Entrez IDs, the second gene
Human Disease Ontology (HDO) ID terms, the third gene HDO description terms.
For human protein-protein interaction (PPI) or disease-gene networks (DGN)
that have human Entrez IDs for the igraph vertex name attribute. The function
then performs a many-to-one mapping of each matrix row to a network vertex
using matching Entrez IDs, filling the vertices attributes
\code{TopOnto_OVG_HDO_ID} and \code{TopOnto_OVG}.
}
\examples{
file <- system.file("extdata", "PPI_Presynaptic.csv", package = "BioNAR")
tbl <- read.csv(file, sep="\t")
gg <- buildNetwork(tbl)
# read HDO data extracted from hxin/topOnto.HDO.db for synaptic network
afile<-system.file("extdata", "flatfile_human_gene2HDO.csv",
package = "BioNAR")
dis    <- read.table(afile, sep="\t", skip=1, header=FALSE,
strip.white=TRUE, quote="")
agg<-annotateTopOntoOVG(gg, dis)
}
\seealso{
getAnnotationVertexList
}
