% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunction.R
\name{makeBsSummaryPlot}
\alias{makeBsSummaryPlot}
\title{Plot binding site filter diagnostics}
\usage{
makeBsSummaryPlot(object)
}
\arguments{
\item{object}{a \code{\link{BSFDataSet}} object}
}
\value{
a plot of type \code{\link{ggplot}}
}
\description{
A diagnostic function that plots the number of binding sites retained
after each filtering step calculated in \code{\link{makeBindingSites}}.
The function \code{\link{makeBindingSites}} is expected to be executed prior
to calling this plot function.
}
\examples{
# load clip data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))
bds = makeBindingSites(object = bds, bsSize = 9)
makeBsSummaryPlot(bds)

}
\seealso{
\code{\link{makeBindingSites}}
}
