% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deleteLocalData.R
\name{deleteOldData}
\alias{deleteOldData}
\title{Delete .rds data of one species coming from an old version of the BgeeDB R package.}
\usage{
deleteOldData(myBgeeObject)
}
\arguments{
\item{myBgeeObject}{A Reference Class Bgee object, notably specifying the targeted species}
}
\description{
Since Bioconductor 3.11 BgeeDB store data in a local SQLite database allowing
to optimize memory usage.
This function allows to delete .rds files used to store local data from BgeeDB versions older
than Bioconductor 3.11, for the species selected in the reference class Bgee object.
}
\examples{
{
  bgee <- Bgee$new(species = "Mus_musculus", dataType = "rna_seq")
  deleteOldData(bgee)
}

}
\author{
Julien Wollbrett
}
