% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KallistoMetadata.R
\docType{class}
\name{KallistoMetadata-class}
\alias{KallistoMetadata-class}
\alias{KallistoMetadata}
\title{KallistoMetadata S4 class}
\description{
An S4 class that is the desendant of the AbundanceMetadata class. 
It contains all metadata needed to run kallisto analysis.
All slots of this class have a default value. You do not need to edit them to 
run the package
}
\section{Slots}{

\describe{
\item{\code{download_kallisto}}{A logical allowing to use an already installed version 
of kallisto or to download a version that will be used only by this package}

\item{\code{kallisto_windows_url}}{URL to the binary of kallisto for windows}

\item{\code{kallisto_linux_url}}{URL to the binary of kallisto for linux}

\item{\code{kallisto_osx_url}}{URL to the binary of kallisto for MacOS}

\item{\code{kallisto_windows_dir}}{Name of the directory where kallisto will be installed
on windows}

\item{\code{kallisto_linux_dir}}{Name of the directory where kallisto will be installed
on linux}

\item{\code{kallisto_osx_dir}}{Name of the directory where kallisto will be installed
on Mac}

\item{\code{unix_kallisto_name}}{Name of the kallisto executable in linux and macOS}

\item{\code{windows_kallisto_name}}{Name of the kallisto executable in windows}

\item{\code{index_file}}{Name of index file generated by kallisto with default kmer 
size. It will be generated using the fasta file that contains both 
transcriptomic and intergenic regions. Do not use an index you generated 
outside of this package. This file is created by the pipeline. 
You should edit this slot only if you already have such a file with a 
different name. This file must be store at get_tool_path()}

\item{\code{k15_index_file}}{same as index_file. This index is generated with smallest 
kmers and will be used only for libraries containing reads smallest than 50nt.}

\item{\code{single_end_parameters}}{kallisto parameters used to run a single end mapping}

\item{\code{pair_end_parameters}}{kallisto parameters used to run a pair end mapping}

\item{\code{overwrite_index}}{logical allowing to overwrite already existing index. FALSE by
default. Then by default already existing index files will not be generated again.}

\item{\code{overwrite_quant}}{logical allowing to overwrite already existing abundance.txt 
files. FALSE by default. Then by default already existing quantitfdication files will 
not be generated again.}

\item{\code{overwrite_calls}}{logical allowing to overwrite already existing present/absent 
calls. FALSE by default. Then by default already generated calls will not be 
generated again.}
}}

