% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialPlot.R
\name{clusterPlot}
\alias{clusterPlot}
\title{Plot spatial cluster assignments.}
\usage{
clusterPlot(
  sce,
  label = "spatial.cluster",
  palette = NULL,
  color = NULL,
  platform = NULL,
  is.enhanced = NULL,
  nsubspots.per.edge = 3,
  ...
)
}
\arguments{
\item{sce}{SingleCellExperiment. If \code{fill} is specified and is a string,
it must exist as a column in \code{colData(sce)}.}

\item{label}{Labels used to color each spot. May be the name of a column in
\code{colData(sce)}, or a vector of discrete values.}

\item{palette}{Optional vector of hex codes to use for discrete spot values.}

\item{color}{Optional hex code to set color of borders around spots. Set to
\code{NA} to remove borders.}

\item{platform}{Spatial sequencing platform. If "Visium", the hex spot layout
will be used, otherwise square spots will be plotted.\cr
NOTE: specifying this argument is only necessary if \code{sce} was not
created by \code{spatialCluster()} or \code{spatialEnhance()}.}

\item{is.enhanced}{True if \code{sce} contains subspot-level data instead of
spots. Spatial sequencing platform. If true, the respective subspot lattice
for each platform will be plotted.\cr
NOTE: specifying this argument is only necessary if \code{sce} was not
created by \code{spatialCluster()} or \code{spatialEnhance()}.}

\item{nsubspots.per.edge}{Number of subspots per edge of the square. Only
valid when \code{platform} is 'ST' or 'VisiumHD'.}

\item{...}{Additional arguments for \code{geom_polygon()}. \code{size}, to
specify the linewidth of these borders, is likely the most useful.}
}
\value{
Returns a ggplot object.
}
\description{
Plot spatial cluster assignments.
}
\examples{
sce <- exampleSCE()
clusterPlot(sce)

}
\seealso{
Other spatial plotting functions: 
\code{\link{featurePlot}()}
}
\concept{spatial plotting functions}
