% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesKnockdown.r
\name{BayesKnockdown}
\alias{BayesKnockdown}
\title{Posterior Probabilities for Knockdown Data}
\usage{
BayesKnockdown(x, y, prior = 0.5, g = sqrt(length(x)))
}
\arguments{
\item{x}{\code{n}-vector of predictor data. In knockdown experiments, this is
a vector of the expression levels of the knocked-down gene across
n experiments.}

\item{y}{Outcome matrix: \code{p} (number of outcomes measured) by \code{n} (number of samples).
In knockdown experiments, this is a matrix of all the gene measurements
for genes that were not knocked down.}

\item{prior}{Prior probabilities for the outcome variables. Defaults to 0.5
for all variables.}

\item{g}{The value to use for Zellner's \emph{g}-prior.
Defaults to the square root of the number of observations.}
}
\value{
A vector of \code{p} posterior probabilities indicating
             the probability of a relationship between the predictor variable
             and each outcome variable.
}
\description{
Calculates posterior probabilities for edges from a knocked-down gene
to each of a set of potential target genes. More generally, it
calculates posterior probabilities between a single predictor variable
and each of a set of response variables, incorporating prior probabilities
potentially unique to each response variable.
}
\examples{
n <- 100;
p <- 10;
x <- rnorm(n);
y <- matrix(nrow=p, data=rnorm(n*p));
y[3,] <- y[3,] + 0.5*x;

BayesKnockdown(x, y);
}

