% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_statistic.R
\name{run_lambda}
\alias{run_lambda}
\title{Provide a recommendation on batch correction based on lambda calculation}
\usage{
run_lambda(se, assay, batch, condition)
}
\arguments{
\item{se}{summarized experiment object}

\item{assay}{string, the assay to analyze}

\item{batch}{string, batch variable}

\item{condition}{string, condition variable}
}
\value{
a named list with:
\describe{
\item{lambda_stat}{provides the output of \code{compute_lambda} function}
\item{correction_recommendation}{string, rec for batch correction}
}

a list with 2 parameters, 'lambda_stat' which contains the adj lambda
value from lambda_compute (ln(lambda)) or 'NULL' if the design is balanced,
and 'correction_recommendation' which contains a string with a
recommendation on if batch correction should be completed
}
\description{
This functions determines if an experimental design is balanced, then
calculates the lambda statistic for balanced designs and provides a
recommendation on if batch correction should be utilized. In general,
unbalanced designs always benefit from batch correction, while balanced
designs with a lambda greater than -2 benefit from batch correction.
}
\examples{

library(scran)
se <- mockSCE()
lambda_calculation <- run_lambda(se,
                                 assay = "counts",
                                 batch = "Mutation_Status",
                                 condition = "Treatment")
 print(lambda_calculation$correction_recommendation)
 print(lambda_calculation$lambda_stat)

}
