% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BaalChIP-generics.R, R/BaalChIP-methods.R
\name{adjustmentBaalPlot}
\alias{adjustmentBaalPlot}
\alias{adjustmentBaalPlot,BaalChIP-method}
\title{Method adjustmentBaalPlot}
\usage{
adjustmentBaalPlot(.Object, col = c("green3", "gray50"))

\S4method{adjustmentBaalPlot}{BaalChIP}(.Object, col = c("green3", "gray50"))
}
\arguments{
\item{.Object}{An object of the \code{\link{BaalChIP}} class.}

\item{col}{A character vector indicating the colours for the density plot ( default is c( 'green3','gray50') ).}
}
\value{
A plot
}
\description{
Produces a density plot of the distribution of allelic ratios (REF/TOTAL) before and after BaalChIP adjustment for RM and RAF biases.
}
\examples{
data('BaalObject')
adjustmentBaalPlot(BaalObject)
adjustmentBaalPlot(BaalObject, col=c('blue','pink'))
}
\seealso{
\code{\link{BaalChIP.report}}, \code{\link{summaryQC}}
}
\author{
Ines de Santiago
}
