% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BaalChIP-generics.R, R/BaalChIP-methods.R
\name{QCfilter}
\alias{QCfilter}
\alias{QCfilter,BaalChIP-method}
\title{Method QCfilter}
\usage{
QCfilter(.Object, RegionsToFilter = NULL, RegionsToKeep = NULL, verbose = TRUE)

\S4method{QCfilter}{BaalChIP}(.Object, RegionsToFilter = NULL, RegionsToKeep = NULL, verbose = TRUE)
}
\arguments{
\item{.Object}{An object of the \code{\link{BaalChIP}} class.}

\item{RegionsToFilter}{a named list of GRanges objects. Variants overlapping these regions will be removed.}

\item{RegionsToKeep}{a named list of GRanges objects. Works in an oposite way to 'RegionstoFilter', variants NOT overlapping these regions will be removed.}

\item{verbose}{logical. If TRUE reports extra information on the process}
}
\value{
An updated \code{\link{BaalChIP}} object with the slot \code{alleleCounts} containing a list of GRanges objects that pass filters.
}
\description{
Quality control step for removing variants that may be problematic for identification of allele-specific events.
}
\examples{
samplesheet <- system.file("test", "exampleChIP.tsv", package = "BaalChIP")  
hets <- c("MCF7"= system.file("test", "MCF7_hetSNP.txt", package = "BaalChIP"), 
         "GM12891"= system.file("test", "GM12891_hetSNP.txt", package = "BaalChIP"))
res <- BaalChIP(samplesheet=samplesheet, hets=hets)
res <- alleleCounts(res, min_base_quality=10, min_mapq=15)
data('blacklist_hg19')
data('pickrell2011cov1_hg19')
data('UniqueMappability50bp_hg19')
res <- QCfilter(res,
               RegionsToFilter=list('blacklist'=blacklist_hg19,
               'highcoverage'=pickrell2011cov1_hg19),
               RegionsToKeep=list('UniqueMappability'=UniqueMappability50bp_hg19))

#check results
plotQC(res,'barplot')
summaryQC(res)
}
\seealso{
\code{\link{BaalChIP.get}}, \code{\link{plotQC}}, \code{\link{summaryQC}}
}
\author{
Ines de Santiago
}
