% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{BASiCS_ResultVG}
\alias{BASiCS_ResultVG}
\alias{BASiCS_ResultVG-class}
\title{The BASiCS_ResultVG class}
\description{
Container of results for a single HVG/LVG test.
}
\section{Slots}{

\describe{
\item{\code{Method}}{Character value detailing whether the test performed using 
a threshold directly on epsilon values (\code{Method="Epsilon"}),
variance decomposition (\code{Method="Variance"}) or percentiles of epsilon 
(\code{Method="Percentile"}).}

\item{\code{RowData}}{Optional \link[S4Vectors]{DataFrame-class} containing 
additional information about genes used in the test.}

\item{\code{EFDRgrid,EFNRgrid}}{Grid of EFDR and EFNR values calculated before 
thresholds were fixed.}

\item{\code{Threshold}}{Threshold used to calculate tail posterior probabilities 
for the HVG or LVG decision rule.}

\item{\code{ProbThresholds}}{Probability thresholds used to calculate 
\code{EFDRGrid} and \code{EFNRGrid}.}

\item{\code{ProbThreshold}}{Posterior probability threshold used in the HVG/LVG 
decision rule.}
}}

