% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BASiCS_DivideAndConquer.R
\name{BASiCS_DivideAndConquer}
\alias{BASiCS_DivideAndConquer}
\title{Run divide and conquer MCMC with BASiCS}
\usage{
BASiCS_DivideAndConquer(
  Data,
  NSubsets = 5,
  SubsetBy = c("cell", "gene"),
  EtaSqThreshold = 0.06,
  WithSpikes,
  Regression,
  BPPARAM = BiocParallel::bpparam(),
  PriorParam = BASiCS_PriorParam(Data, PriorMu = "EmpiricalBayes"),
  RunName,
  StoreChains,
  StoreDir,
  Start,
  ...
)
}
\arguments{
\item{Data}{SingleCellExperiemnt object}

\item{NSubsets}{The number of batches to create and perform MCMC inference
with.}

\item{SubsetBy}{A character value specifying whether batches should consist
of a subset of the cells in \code{Data} (when \code{SubsetBy="cell"})
or a subset of the genes in \code{Data} (when \code{SubsetBy="gene"}).}

\item{EtaSqThreshold}{A numeric value specifying the eta-squared
used to determine whether the average library size or average count
are substantially different between batches.}

\item{WithSpikes, Regression, PriorParam}{See \code{\link{BASiCS_MCMC}}.}

\item{BPPARAM}{A \code{\link[BiocParallel]{BiocParallelParam}} instance.}

\item{RunName, StoreChains, StoreDir, Start}{Unused. If used when calling this
function, they are likely to result in undefined behaviour.}

\item{...}{Passed to  \code{\link{BASiCS_MCMC}}. All arguments required by
\code{\link{BASiCS_MCMC}} must be supplied here, for example
\code{N}, \code{Thin}, \code{Burn}.}
}
\value{
A list of \linkS4class{BASiCS_Chain} objects.
}
\description{
Performs MCMC inference on batches of data. \code{Data} is divided
into \code{NSubsets} batches, and \code{BASiCS_MCMC} is run on each
batch separately.
}
\details{
Subsets are chosen such that the average library size (when partitioning
by cells) or average count (when partitioning by genes) is not significantly
different between batches, at threshold \code{EtaSqThreshold}.
}
\examples{
 bp <- BiocParallel::SnowParam()
 Data <- BASiCS_MockSCE()
 BASiCS_DivideAndConquer(
   Data, 
   NSubsets = 2,
   SubsetBy = "gene",
   N = 8,
   Thin = 2,
   Burn = 4,
   WithSpikes = TRUE,
   Regression = TRUE,
   BPPARAM = bp
 )
}
\references{
Simple, Scalable and Accurate Posterior Interval Estimation
Cheng Li and Sanvesh Srivastava and David B. Dunson
arXiv (2016)
}
