% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_helpers.R
\name{nmr_pca_outliers_plot}
\alias{nmr_pca_outliers_plot}
\title{Plot for outlier detection diagnostic}
\usage{
nmr_pca_outliers_plot(nmr_dataset, pca_outliers, ...)
}
\arguments{
\item{nmr_dataset}{An \link{nmr_dataset_1D} object}

\item{pca_outliers}{The output from \code{\link[=nmr_pca_outliers]{nmr_pca_outliers()}}}

\item{...}{Additional parameters passed on to \code{\link[ggplot2:aes]{ggplot2::aes()}} (or now deprecated to \code{\link[ggplot2:aes_]{ggplot2::aes_string()}})}
}
\value{
A plot for the outlier detection
}
\description{
Plot for outlier detection diagnostic
}
\examples{
# dir_to_demo_dataset <- system.file("dataset-demo", package = "AlpsNMR")
# dataset <- nmr_read_samples_dir(dir_to_demo_dataset)
# dataset_1D <- nmr_interpolate_1D(dataset, axis = c(min = -0.5, max = 10, by = 2.3E-4))
# model <- nmr_pca_build_model(dataset_1D)
# outliers_info <- nmr_pca_outliers(dataset_1D, model)
# nmr_pca_outliers_plot(dataset_1D, outliers_info)

}
\seealso{
Other PCA related functions: 
\code{\link{nmr_pca_build_model}()},
\code{\link{nmr_pca_outliers}()},
\code{\link{nmr_pca_outliers_filter}()},
\code{\link{nmr_pca_outliers_robust}()},
\code{\link{nmr_pca_plots}}

Other outlier detection functions: 
\code{\link{Pipelines}},
\code{\link{nmr_pca_outliers}()},
\code{\link{nmr_pca_outliers_filter}()},
\code{\link{nmr_pca_outliers_robust}()}
}
\concept{PCA related functions}
\concept{outlier detection functions}
