% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_helpers.R
\name{nmr_pca_outliers}
\alias{nmr_pca_outliers}
\title{Compute PCA residuals and score distance for each sample}
\usage{
nmr_pca_outliers(
  nmr_dataset,
  pca_model,
  ncomp = NULL,
  quantile_critical = 0.975
)
}
\arguments{
\item{nmr_dataset}{An \link{nmr_dataset_1D} object}

\item{pca_model}{A pca model returned by \link{nmr_pca_build_model}}

\item{ncomp}{Number of components to use. Use \code{NULL} for 90\% of the variance}

\item{quantile_critical}{critical quantile}
}
\value{
A list with:
\itemize{
\item outlier_info: A data frame with the NMRExperiment, the Q residuals and T scores
\item ncomp: Number of components used to compute Q and T
\item Tscore_critical, QResidual_critical: Critical values, given a quantile, for both Q and T.
}
}
\description{
Compute PCA residuals and score distance for each sample
}
\examples{
dir_to_demo_dataset <- system.file("dataset-demo", package = "AlpsNMR")
dataset <- nmr_read_samples_dir(dir_to_demo_dataset)
dataset_1D <- nmr_interpolate_1D(dataset, axis = c(min = -0.5, max = 10, by = 2.3E-4))
model <- nmr_pca_build_model(dataset_1D)
outliers_info <- nmr_pca_outliers(dataset_1D, model)

}
\seealso{
Other PCA related functions: 
\code{\link{nmr_pca_build_model}()},
\code{\link{nmr_pca_outliers_filter}()},
\code{\link{nmr_pca_outliers_plot}()},
\code{\link{nmr_pca_outliers_robust}()},
\code{\link{nmr_pca_plots}}

Other outlier detection functions: 
\code{\link{Pipelines}},
\code{\link{nmr_pca_outliers_filter}()},
\code{\link{nmr_pca_outliers_plot}()},
\code{\link{nmr_pca_outliers_robust}()}
}
\concept{PCA related functions}
\concept{outlier detection functions}
