% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmr_meta.R
\name{nmr_meta_get_column}
\alias{nmr_meta_get_column}
\title{Get a single metadata column}
\usage{
nmr_meta_get_column(samples, column = "NMRExperiment")
}
\arguments{
\item{samples}{a \link{nmr_dataset_family} object}

\item{column}{A column to get}
}
\value{
A vector with the column
}
\description{
Get a single metadata column
}
\examples{
dir_to_demo_dataset <- system.file("dataset-demo", package = "AlpsNMR")
dataset <- nmr_read_samples_dir(dir_to_demo_dataset)
metadata_column <- nmr_meta_get_column(dataset)

}
\seealso{
Other metadata functions: 
\code{\link{Pipelines}},
\code{\link{nmr_meta_add}()},
\code{\link{nmr_meta_export}()},
\code{\link{nmr_meta_get}()},
\code{\link{nmr_meta_groups}()}

Other nmr_dataset functions: 
\code{\link{nmr_meta_add}()},
\code{\link{nmr_meta_export}()},
\code{\link{nmr_meta_get}()}

Other nmr_dataset_1D functions: 
\code{\link{[.nmr_dataset_1D}()},
\code{\link{format.nmr_dataset_1D}()},
\code{\link{get_integration_with_metadata}()},
\code{\link{is.nmr_dataset_1D}()},
\code{\link{nmr_integrate_peak_positions}()},
\code{\link{nmr_integrate_regions}()},
\code{\link{nmr_meta_add}()},
\code{\link{nmr_meta_export}()},
\code{\link{nmr_meta_get}()},
\code{\link{nmr_ppm_resolution}()},
\code{\link{print.nmr_dataset_1D}()}

Other nmr_dataset_peak_table functions: 
\code{\link{nmr_meta_add}()},
\code{\link{nmr_meta_export}()},
\code{\link{nmr_meta_get}()}
}
\concept{metadata functions}
\concept{nmr_dataset functions}
\concept{nmr_dataset_1D functions}
\concept{nmr_dataset_peak_table functions}
