% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmr_interpolate.R
\name{nmr_interpolate_1D}
\alias{nmr_interpolate_1D}
\alias{nmr_interpolate_1D.nmr_dataset}
\title{Interpolate a set of 1D NMR Spectra}
\usage{
nmr_interpolate_1D(samples, axis = c(min = 0.2, max = 10, by = 8e-04))

\method{nmr_interpolate_1D}{nmr_dataset}(samples, axis = c(min = 0.2, max = 10, by = 8e-04))
}
\arguments{
\item{samples}{An NMR dataset}

\item{axis}{The ppm axis range and optionally the ppm step. Set it to \code{NULL} for autodetection}
}
\value{
Interpolate a set of 1D NMR Spectra
}
\description{
Interpolate a set of 1D NMR Spectra
}
\examples{
dir_to_demo_dataset <- system.file("dataset-demo", package = "AlpsNMR")
dataset <- nmr_read_samples_dir(dir_to_demo_dataset)
dataset_1D <- nmr_interpolate_1D(dataset, axis = c(min = -0.5, max = 10, by = 2.3E-4))

dir_to_demo_dataset <- system.file("dataset-demo", package = "AlpsNMR")
dataset <- nmr_read_samples_dir(dir_to_demo_dataset)
dataset_1D <- nmr_interpolate_1D(dataset, axis = c(min = -0.5, max = 10, by = 2.3E-4))

}
