% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmr_detect_peaks_align.R
\name{nmr_detect_peaks_plot_overview}
\alias{nmr_detect_peaks_plot_overview}
\title{Overview of the peak detection results}
\usage{
nmr_detect_peaks_plot_overview(
  peak_data,
  ppm_breaks = pretty(range(peak_data$ppm), n = 20),
  accepted_only = TRUE
)
}
\arguments{
\item{peak_data}{The output of \code{\link[=nmr_detect_peaks]{nmr_detect_peaks()}}}

\item{ppm_breaks}{A numeric vector with the breaks that will be used to count the number of the detected peaks.}

\item{accepted_only}{If \code{peak_data} contains a logical column named \code{accepted}, only those with \code{accepted=TRUE} will be counted.}
}
\value{
A scatter plot, with samples on one axis and chemical shift bins in the other axis. The size of each dot
represents the number of peaks found on a sample within a chemical shift range.
}
\description{
This plot allows to explore the performance of the peak detection across all the samples, by summarizing
how many peaks are detected on each sample at each chemical shift range.
}
\details{
You can use this plot to find differences in the number of detected peaks across your dataset, and then use
\code{\link[=nmr_detect_peaks_plot]{nmr_detect_peaks_plot()}} to have a finer look at specific samples and chemical shifts, and assess graphically that the
peak detection results that you have are correct.
}
\seealso{
Peak_detection

Other peak detection functions: 
\code{\link{Pipelines}},
\code{\link{nmr_baseline_threshold}()},
\code{\link{nmr_detect_peaks}()},
\code{\link{nmr_detect_peaks_plot}()},
\code{\link{nmr_detect_peaks_tune_snr}()},
\code{\link{nmr_identify_regions_blood}()},
\code{\link{nmr_identify_regions_cell}()},
\code{\link{nmr_identify_regions_urine}()},
\code{\link{nmr_integrate_regions}()}
}
\concept{peak detection functions}
