% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmr_data.R
\name{nmr_data}
\alias{nmr_data}
\alias{nmr_data.nmr_dataset_1D}
\alias{nmr_data<-}
\alias{nmr_data<-.nmr_dataset_1D}
\title{Set/Return the full spectra matrix}
\usage{
nmr_data(nmr_dataset, ...)

\method{nmr_data}{nmr_dataset_1D}(nmr_dataset, what = "data_1r", ...)

nmr_data(nmr_dataset, ...) <- value

\method{nmr_data}{nmr_dataset_1D}(nmr_dataset, what = "data_1r", ...) <- value
}
\arguments{
\item{nmr_dataset}{An object from the \link{nmr_dataset_family} to get the raw data from}

\item{...}{Passed on to methods for compatibility}

\item{what}{What data do we want to get (default: \code{data_1r})}

\item{value}{A matrix}
}
\value{
a matrix

The given nmr_dataset
}
\description{
Set/Return the full spectra matrix
}
\examples{
dataset_rds <- system.file("extdata", "nmr_dataset.rds", package = "AlpsNMR")
dataset_1D <- nmr_dataset_load(dataset_rds)
dataset_data <- nmr_data(dataset_1D)
dataset_rds <- system.file("extdata", "nmr_dataset.rds", package = "AlpsNMR")
dataset_1D <- nmr_dataset_load(dataset_rds)
dataset_1D_data <- nmr_data(dataset_1D)
}
\seealso{
Other import/export functions: 
\code{\link{Pipelines}},
\code{\link{files_to_rDolphin}()},
\code{\link{load_and_save_functions}},
\code{\link{nmr_meta_export}()},
\code{\link{nmr_read_bruker_fid}()},
\code{\link{nmr_read_samples}()},
\code{\link{nmr_zip_bruker_samples}()},
\code{\link{save_files_to_rDolphin}()},
\code{\link{save_profiling_output}()},
\code{\link{to_ChemoSpec}()}
}
\concept{import/export functions}
