% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmr_dataset_1D.R
\name{new_nmr_dataset_1D}
\alias{new_nmr_dataset_1D}
\title{Creates a new 1D nmr_dataset object from scratch}
\usage{
new_nmr_dataset_1D(ppm_axis, data_1r, metadata)
}
\arguments{
\item{ppm_axis}{A numeric vector with the ppm values for the columns of data_1r}

\item{data_1r}{A numeric matrix with one NMR spectrum on each row}

\item{metadata}{A list of data frames with at least the \code{NMRExperiment} column}
}
\value{
Creates a new 1D nmr_dataset object from scratch
}
\description{
Creates a new 1D nmr_dataset object from scratch
}
\examples{
# Create a random spectra matrix
nsamp <- 12
npoints <- 20
dummy_ppm_axis <- seq(from = 0.2, to = 10, length.out = npoints)
dummy_spectra_matrix <- matrix(runif(nsamp * npoints), nrow = nsamp, ncol = npoints)
metadata <- list(external = data.frame(
    NMRExperiment = paste0("Sample", 1:12),
    DummyClass = c("a", "b")
))
dummy_nmr_dataset_1D <- new_nmr_dataset_1D(
    ppm_axis = dummy_ppm_axis,
    data_1r = dummy_spectra_matrix,
    metadata = metadata
)

}
\seealso{
Other class helper functions: 
\code{\link{format.nmr_dataset}()},
\code{\link{format.nmr_dataset_1D}()},
\code{\link{format.nmr_dataset_peak_table}()},
\code{\link{is.nmr_dataset_1D}()},
\code{\link{is.nmr_dataset_peak_table}()},
\code{\link{new_nmr_dataset}()},
\code{\link{new_nmr_dataset_peak_table}()},
\code{\link{print.nmr_dataset}()},
\code{\link{print.nmr_dataset_1D}()},
\code{\link{print.nmr_dataset_peak_table}()},
\code{\link{validate_nmr_dataset}()},
\code{\link{validate_nmr_dataset_family}()},
\code{\link{validate_nmr_dataset_peak_table}()}
}
\concept{class helper functions}
