% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmr_integrate_regions.R
\name{get_integration_with_metadata}
\alias{get_integration_with_metadata}
\title{Get integrals with metadata from \verb{integrate peak positions}}
\usage{
get_integration_with_metadata(integration_object)
}
\arguments{
\item{integration_object}{A \link{nmr_dataset} object}
}
\value{
Get integrals with metadata from \verb{integrate peak positions}

integration dataframe
}
\description{
Get integrals with metadata from \verb{integrate peak positions}
}
\examples{
peak_table <- matrix(1:6, nrow = 2, ncol = 3)
rownames(peak_table) <- c("10", "20")
colnames(peak_table) <- c("ppm_1.2", "ppm1.4", "ppm1.6")

dataset <- new_nmr_dataset_peak_table(
    peak_table = peak_table,
    metadata = list(external = data.frame(NMRExperiment = c("10", "20"), Condition = c("A", "B")))
)
get_integration_with_metadata(dataset)
}
\seealso{
Other peak integration functions: 
\code{\link{Pipelines}},
\code{\link{nmr_identify_regions_blood}()},
\code{\link{nmr_identify_regions_cell}()},
\code{\link{nmr_identify_regions_urine}()},
\code{\link{nmr_integrate_peak_positions}()},
\code{\link{nmr_integrate_regions}()}

Other nmr_dataset_1D functions: 
\code{\link{[.nmr_dataset_1D}()},
\code{\link{format.nmr_dataset_1D}()},
\code{\link{is.nmr_dataset_1D}()},
\code{\link{nmr_integrate_peak_positions}()},
\code{\link{nmr_integrate_regions}()},
\code{\link{nmr_meta_add}()},
\code{\link{nmr_meta_export}()},
\code{\link{nmr_meta_get}()},
\code{\link{nmr_meta_get_column}()},
\code{\link{nmr_ppm_resolution}()},
\code{\link{print.nmr_dataset_1D}()}
}
\concept{nmr_dataset_1D functions}
\concept{peak integration functions}
