% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmr_dataset_1D.R
\name{SummarizedExperiment_to_nmr_data_1r}
\alias{SummarizedExperiment_to_nmr_data_1r}
\title{Import SummarizedExperiment as 1D NMR data}
\usage{
SummarizedExperiment_to_nmr_data_1r(se)
}
\arguments{
\item{se}{An SummarizedExperiment object}
}
\value{
nmr_dataset An \link{nmr_dataset_1D} object (unmodified)
}
\description{
Import SummarizedExperiment as 1D NMR data
}
\examples{
dir_to_demo_dataset <- system.file("dataset-demo", package = "AlpsNMR")
dataset <- nmr_read_samples_dir(dir_to_demo_dataset)
dataset_1D <- nmr_interpolate_1D(dataset, axis = c(min = -0.5, max = 10, by = 2.3E-4))
se <- nmr_data_1r_to_SummarizedExperiment(dataset_1D)
dataset_1D <- SummarizedExperiment_to_nmr_data_1r(se)
}
