% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AlpsNMR.R
\docType{package}
\name{AlpsNMR-package}
\alias{AlpsNMR}
\alias{AlpsNMR-package}
\title{AlpsNMR: Automated spectraL Processing System for NMR}
\description{
AlpsNMR allows you to import NMR spectra into R and provides automated and efficient signal processing for untargeted NMR metabolomics.
}
\details{
The following functions can be combined with the pipe. They
create or modify the \link{nmr_dataset} object.
\itemize{
\item \code{\link[=nmr_read_samples_dir]{nmr_read_samples_dir()}} or \code{\link[=nmr_read_samples]{nmr_read_samples()}}
\item \code{\link[=nmr_interpolate_1D]{nmr_interpolate_1D()}}
\item \code{\link[=nmr_exclude_region]{nmr_exclude_region()}}
\item \code{\link[=nmr_normalize]{nmr_normalize()}}
\item \link[=plot.nmr_dataset_1D]{plot()}
}

There are also functions to extract the metadata and submit the samples to
irods, see the example below.

The \link{nmr_dataset} object is essentially a list, so it is easy to access
its components for further analysis.
}
\examples{
dir_to_demo_dataset <- system.file("dataset-demo", package = "AlpsNMR")
dataset <- nmr_read_samples_dir(dir_to_demo_dataset)
my_nmr_dataset <- dataset \%>\%
    nmr_interpolate_1D(axis = c(0.4, 10)) \%>\%
    nmr_exclude_region(exclude = list(water = c(4.6, 5))) \%>\%
    nmr_normalize(method = "pqn") \%>\%
    plot()
}
\seealso{
Useful links:
\itemize{
  \item \url{https://sipss.github.io/AlpsNMR/}
  \item \url{https://github.com/sipss/AlpsNMR}
  \item Report bugs at \url{https://github.com/sipss/AlpsNMR/issues}
}

}
\author{
\strong{Maintainer}: Sergio Oller Moreno \email{sergioller@gmail.com} (\href{https://orcid.org/0000-0002-8994-1549}{ORCID})

Authors:
\itemize{
  \item Ivan Montoliu Roura \email{Ivan.MontoliuRoura@rd.nestle.com}
  \item Francisco Madrid Gambin \email{fmadrid@ibecbarcelona.eu} (\href{https://orcid.org/0000-0001-9333-0014}{ORCID})
  \item Luis Fernandez \email{lfernandez@ibecbarcelona.eu} (\href{https://orcid.org/0000-0001-9790-6287}{ORCID})
  \item Héctor Gracia Cabrera \email{hgracia@ibecbarcelona.eu}
  \item Santiago Marco Colás \email{smarco@ibecbarcelona.eu} (\href{https://orcid.org/0000-0003-2663-2965}{ORCID})
}

Other contributors:
\itemize{
  \item Laura López Sánchez [contributor]
  \item Nestlé Institute of Health Sciences [copyright holder]
  \item Institute for Bioengineering of Catalonia [copyright holder]
  \item Miller Jack \email{jack.miller@physics.org} (\href{https://orcid.org/0000-0002-6258-1299}{ORCID}) (Autophase wrapper, ASICS export) [contributor]
}

}
