% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxillary-methods.R
\docType{methods}
\name{phaseMatrix2Array}
\alias{phaseMatrix2Array}
\alias{phaseMatrix2Array,matrix-method}
\title{phaseMatrix2Array}
\usage{
phaseMatrix2Array(x, ...)

\S4method{phaseMatrix2Array}{matrix}(x, dimnames = NULL, ...)
}
\arguments{
\item{x}{matrix see examples}

\item{...}{arguments to forward to internal functions}

\item{dimnames}{list with dimnames}
}
\description{
used to convert the phase from the visually friendly matrix to array.
}
\details{
A more effectice way of store the phase data in the ASEset object
}
\examples{

#load data
data(ASEset)
a <- ASEset

#example phase matrix
p1 <- matrix(sample(c(1,0),replace=TRUE, size=nrow(a)*ncol(a)),nrow=nrow(a), ncol(a))
p2 <- matrix(sample(c(1,0),replace=TRUE, size=nrow(a)*ncol(a)),nrow=nrow(a), ncol(a))
p <- matrix(paste(p1,sample(c("|","|","/"), size=nrow(a)*ncol(a), replace=TRUE), p2, sep=""),
	nrow=nrow(a), ncol(a))

ar <- phaseMatrix2Array(p)

}
\author{
Jesper R. Gadin, Lasse Folkersen
}
\keyword{phase}
