% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxillary-methods.R
\docType{methods}
\name{getAlleleCounts}
\alias{getAlleleCounts}
\alias{getAlleleCounts,GAlignmentsList-method}
\title{snp count data}
\usage{
getAlleleCounts(BamList, ...)

\S4method{getAlleleCounts}{GAlignmentsList}(
  BamList,
  GRvariants,
  strand = "*",
  return.class = "list",
  verbose = TRUE,
  ...
)
}
\arguments{
\item{BamList}{A \code{GAlignmentsList object} or \code{GRangesList object}
containing data imported from a bam file}

\item{...}{parameters to pass on}

\item{GRvariants}{A \code{GRanges object} that contains positions of SNPs to
retrieve}

\item{strand}{A length 1 \code{character} with value  '+',
'-', or '*'.  This argument determines if \code{getAlleleCounts} will
retrieve counts from all reads, or only from reads marked as '+', '-' or '*'
(unknown), respectively.}

\item{return.class}{'list' or 'array'}

\item{verbose}{Setting \code{verbose=TRUE} makes function more talkative}
}
\value{
\code{getAlleleCounts} returns a list of several data.frame objects,
each storing the count data for one SNP.
}
\description{
Given the positions of known SNPs, this function returns allele counts from
a BamGRL object
}
\details{
This function is used to retrieve the allele counts from specified positions
in a set of RNA-seq reads. The \code{BamList} argument will typically have
been created using the \code{impBamGAL} function on bam-files. The
\code{GRvariants} is either a GRanges with user-specified locations or else
it is generated through scanning the same bam-files as in \code{BamList} for
heterozygote locations (e.g. using \code{scanForHeterozygotes}). The
GRvariants will currently only accept locations having width=1,
corresponding to bi-allelic SNPs. In the \code{strand} argument, specifying
'*' is the same as retrieving the sum count of '+' and '-' reads
(and unknown strand reads in case these are found in the bam file). '*' is
the default behaviour and can be used when the RNA-seq experiments strand
information is not available.
}
\examples{

#load example data
data(reads)
data(GRvariants)


#get counts at the three positions specified in GRvariants
alleleCount <- getAlleleCounts(BamList=reads,GRvariants,
strand='*')

#if the reads had contained stranded data, these two calls would
#have given the correct input objects for getAlleleCounts
alleleCountPlus <- getAlleleCounts(BamList=reads,GRvariants,
strand='+')
alleleCountMinus <- getAlleleCounts(BamList=reads,GRvariants,
strand='-')


}
\seealso{
\itemize{ \item The \code{\link{scanForHeterozygotes}} which is a
function to find possible heterozygote sites in a
GenomicAlignments object }
}
\author{
Jesper R. Gadin, Lasse Folkersen
}
\keyword{SNP}
\keyword{count}
