% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxillary-methods.R
\docType{methods}
\name{fractionPlotDf}
\alias{fractionPlotDf}
\alias{fractionPlotDf,ASEset-method}
\title{Plot Dataframe}
\usage{
fractionPlotDf(x, snp, strand = "*", top.fraction.criteria = "maxcount", ...)

\S4method{fractionPlotDf}{ASEset}(x, snp, strand = "*", top.fraction.criteria = "maxcount", ...)
}
\arguments{
\item{x}{ASEset}

\item{snp}{rownames identifier for ASEset or row number}

\item{strand}{'+', '-' or '*'}

\item{top.fraction.criteria}{'maxcount', 'ref' or 'phase'}

\item{...}{arguments to forward to internal functions}
}
\description{
Summarizes information to ease creating plots
}
\details{
Main purpose is to reduce the amount of overall code and ease maintenance.

top.fraction.criteria can take three options, maxcount, ref and phase. The top
allele will be every second row in the data frame, with start from row 2.
The maxcount argument will put the allele with most reads on top of the
bivariate fraction. Similarly the ref argument will put always the reference
allele on top. The phase arguments puts the maternal phase always on top.
The top.fraction.criteria for the ref or phase arguments requires that both ref
and alt is set in mcols(ASEset).
}
\examples{

#test on example ASEset
data(ASEset)
a <- ASEset
df <- fractionPlotDf(a, 1, strand="+")

}
\author{
Jesper R. Gadin, Lasse Folkersen
}
\keyword{phase}
\keyword{plotDf}
