% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapbias-methods.R
\docType{methods}
\name{defaultMapBias}
\alias{defaultMapBias}
\alias{defaultMapBias,ASEset-method}
\title{Generate default mapbias from genotype}
\usage{
defaultMapBias(x, ...)

\S4method{defaultMapBias}{ASEset}(x, return.class = "array")
}
\arguments{
\item{x}{\code{ASEset} object}

\item{...}{internal arguments}

\item{return.class}{"array" or "ASEset"}
}
\description{
Create mapbias array from genotype matrix requires genotype information
}
\details{
Default mapbias will be 0.5 for bi-allelic snps and 1 for
homozygots. For genotypes with NA, 0.5 will be placed on all four alleles.
Therefore tri-allelic can not be used atm. Genotype information has to be 
placed in the genotype(x) assay.
}
\examples{

#load example data
data(ASEset.sim)

fasta <- system.file('extdata/hg19.chr17.subset.fa', package='AllelicImbalance')
refAllele(ASEset.sim,fasta=fasta)
a <- refAllele(ASEset.sim,fasta=fasta) 

}
\author{
Jesper R. Gadin, Lasse Folkersen
}
\keyword{mapbias}
