% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_aucellResults.R
\docType{class}
\name{aucellResults-class}
\alias{aucellResults-class}
\alias{aucellResults}
\alias{getAUC}
\alias{getRanking}
\alias{show}
\alias{cbind}
\alias{show,aucellResults-method}
\alias{getAUC,aucellResults-method}
\alias{getRanking,aucellResults-method}
\alias{cbind,aucellResults-method}
\alias{rbind}
\alias{rbind,aucellResults-method}
\title{Wrapper to the matrix that stores the AUC or the cell rankings.}
\usage{
\S4method{show}{aucellResults}(object)

getAUC(object)

\S4method{getAUC}{aucellResults}(object)

getRanking(object)

\S4method{getRanking}{aucellResults}(object)

\S4method{cbind}{aucellResults}(..., deparse.level = 1)

\S4method{rbind}{aucellResults}(..., deparse.level = 1)
}
\arguments{
\item{object}{Results from \code{AUCell_buildRanking}}

\item{...}{(Only for cbind) 

or \code{AUCell_calcAUC}.}

\item{deparse.level}{(Only for cbind)}
}
\value{
\itemize{
\item show: Prints a summary of the object
\item getAUC: Returns the matrix containing the AUC
\item getRanking: Returns the matrix containing the rankings
\item cbind: Combines objects by columns (cbind on \code{assays}); other other slots are conserved from the first object provided as argument.
Both, ranking and AUC are calculated by column (cell or sample). Therefore, it is fine to merge objects as long as they come from equivalent datasets (and keep same genes/genesets, etc...)
}
}
\description{
This class extends SummarizedExperiment to contain the AUC matrix and cell
rankings (as 'assays').

The results are stored in the assays slot, but they can be accessed through
the regular methods (i.e. nrow, rownames... )

Types:

 - "AUC": The assays contains the AUC for the gene-sets (or region-sets)
 & cells.

 - "ranking": The assays contains the gene rankings for each cell.
}
\examples{
# This example is run using a fake expression matrix.
# Therefore, the output will be meaningless.


############# Fake run of AUCell #############
set.seed(123)
exprMatrix <- matrix(data=sample(c(rep(0, 5000), sample(1:3, 5000, replace=TRUE))),
                     nrow=20, 
                     dimnames=list(paste("Gene", 1:20, sep=""), 
                                   paste("Cell", 1:500, sep="")))
dim(exprMatrix)

# Running AUCell
cells_rankings <- AUCell_buildRankings(exprMatrix)
fewGenes <- sample(rownames(exprMatrix), 10)
otherGenes <- sample(rownames(exprMatrix), 5)
geneSets <- list(geneSet1=fewGenes,
                 geneSet2=otherGenes)
cells_AUC <- AUCell_calcAUC(geneSets, cells_rankings, aucMaxRank=5, nCores=1)
##############################################

#Exploring the output:
cells_AUC

class(cells_AUC)

# Extracting the AUC matrix:
getAUC(cells_AUC)[,1:5]

# Subsetting and regular manipulation methods are also available:
cells_AUC[1:2,]
cells_AUC[,3:4]

dim(cells_AUC)
nrow(cells_AUC)
ncol(cells_AUC)
colnames(cells_AUC)
rownames(cells_AUC)

### Merging 2 objects (ranking or AUC):
sample1 <- cells_AUC[,10:20]
sample2 <- cells_AUC[,100:140]
cbind(sample1, sample2)
}
