% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_AUCell_assignCells.R
\name{AUCell_assignCells}
\alias{AUCell_assignCells}
\title{AUCell_assignCells}
\usage{
AUCell_assignCells(cellsAUC, thresholds, nCores = 1)
}
\arguments{
\item{cellsAUC}{AUC object returned by \code{\link{AUCell_calcAUC}}.}

\item{thresholds}{Thresholds selected for each geneset (named vector).}

\item{nCores}{Number of cores to use for computation.}
}
\value{
List with the following elements for each gene-set:
\itemize{
\item 'aucThr' threshold value, in the same format as AUCell_exploreThresholds()
\item 'assignment' List of cells that pass the selected AUC threshold
}
}
\description{
Assigns whether the gene sets are considered "active" on each cell
based on the given thresholds
}
\examples{
# This example is run using a fake expression matrix.
# Therefore, the output will be meaningless.

############# Fake expression matrix #############
set.seed(123)
exprMatrix <- matrix(data=sample(c(rep(0, 5000), sample(1:3, 5000, replace=TRUE))),
                     nrow=20, 
                     dimnames=list(paste("Gene", 1:20, sep=""), 
                                   paste("Cell", 1:500, sep="")))
dim(exprMatrix)
##################################################

######### Previous steps in the workflow #########
# Step 1.
cells_rankings <- AUCell_buildRankings(exprMatrix, plotStats=FALSE)

# Step 2.
# (Gene sets: random genes)
geneSets <- list(geneSet1=sample(rownames(exprMatrix), 10),
                 geneSet2=sample(rownames(exprMatrix), 5))
cells_AUC <- AUCell_calcAUC(geneSets, cells_rankings, aucMaxRank=5)
##################################################

############## Step 3: Assign cells ##############

# 1. Plot histograms and obtain some pre-computed thresholds
# (this example is only meant to show the interface/arguments of the function,
# see the vignette for meaningful examples)
set.seed(123)
par(mfrow=c(1,2)) # Plot is divided into one row and two columns
thresholds <- AUCell_exploreThresholds(cells_AUC, plotHist=TRUE)
thresholds$geneSet1$aucThr

# 2. Obtain cells over a given threshold:
names(which(getAUC(cells_AUC)["geneSet1",] > 0.19))

# Alternative 1: assign cells according to the 'automatic' threshold
cells_assignment <- AUCell_exploreThresholds(cells_AUC,
                                             plotHist=FALSE, assignCells=TRUE)
# Cells assigned:
getAssignments(cells_assignment)
# Threshold applied:
getThresholdSelected(cells_assignment)

# Alternative 2: choose a threshold manually and assign cells
newThresholds = getThresholdSelected(cells_assignment)
newThresholds['geneSet1'] = 0.8
newAssignments = AUCell_assignCells(cells_AUC, newThresholds)
getAssignments(newAssignments)



}
\seealso{
Previous step in the workflow: \code{\link{AUCell_calcAUC}} 
and optionally \code{\link{AUCell_exploreThresholds}} 

See the package vignette for examples and more details:
\code{vignette("AUCell")}
}
