% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSSEscore.R
\name{TSSEscore}
\alias{TSSEscore}
\title{Transcription Start Site (TSS) Enrichment Score}
\usage{
TSSEscore(
  obj,
  txs,
  seqlev = intersect(seqlevels(obj), seqlevels(txs)),
  upstream = 1000,
  downstream = 1000,
  endSize = 100,
  width = 100,
  step = width,
  pseudocount = 0,
  ...
)
}
\arguments{
\item{obj}{an object of \link[GenomicAlignments:GAlignments-class]{GAlignments}}

\item{txs}{GRanges of transcripts}

\item{seqlev}{A vector of characters indicates the sequence levels.}

\item{upstream, downstream}{numeric(1) or integer(1). upstream and downstream of TSS. Default is 1000}

\item{endSize}{numeric(1) or integer(1). the size of the end flanks. Default is 100}

\item{width}{numeric(1) or integer(1). the window size for TSS score. Default is 100.}

\item{step}{numeric(1) or integer(1). The distance between the start position of the sliding windows.}

\item{pseudocount}{numeric(1) or integer(1). Pseudocount. Default is 0. 
If pseudocount is no greater than 0, the features with ZERO or less than ZERO 
counts in flank region will be removed in calculation.}

\item{...}{parameter can be passed to loess.smooth other than 'x', 'y', 'family' and 'evaluation'.}
}
\value{
A object of list with TSS scores
}
\description{
TSS score is a raio between aggregate distribution of reads centered on TSSs and that flanking 
the corresponding TSSs. TSS score = the depth of TSS (each step within 1000 bp each side) / the depth of end flanks (100bp each end).
TSSE score = max(mean(TSS score in each window)).
}
\examples{
 
library(GenomicRanges)
bamfile <- system.file("extdata", "GL1.bam", 
                       package="ATACseqQC", mustWork=TRUE)
gal1 <- readBamFile(bamFile=bamfile, tag=character(0), 
                    which=GRanges("chr1", IRanges(1, 1e6)), 
                    asMates=FALSE)
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
txs <- transcripts(TxDb.Hsapiens.UCSC.hg19.knownGene)
tsse <- TSSEscore(gal1, txs)
}
\references{
https://www.encodeproject.org/data-standards/terms/#enrichment
}
\author{
Jianhong Ou
}
