% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NFRscore.R
\name{NFRscore}
\alias{NFRscore}
\title{Nucleosome Free Regions (NFR) score}
\usage{
NFRscore(
  obj,
  txs,
  seqlev = intersect(seqlevels(obj), seqlevels(txs)),
  nucleosomeSize = 150,
  nucleosomeFreeSize = 100
)
}
\arguments{
\item{obj}{an object of \link[GenomicAlignments:GAlignments-class]{GAlignments}}

\item{txs}{GRanges of transcripts}

\item{seqlev}{A vector of characters indicates the sequence levels.}

\item{nucleosomeSize}{numeric(1) or integer(1). Default is 150}

\item{nucleosomeFreeSize}{numeric(1) or integer(1). Default is 100}
}
\value{
A object of \link[GenomicRanges:GRanges-class]{GRanges} with NFR scores
}
\description{
NFR score is a raio between cut signal adjacent to TSS and that flanking 
the corresponding TSS. Each TSS window of 400 bp is first seperated into 3 sub-regions: 
the most upstream 150 bp (n1), the most downstream of 150 bp (n2), and the middle 100 bp (nf). 
Then the number of fragments with 5' ends overlapping each region are calculated for each TSS.
The NFR score for each TSS is calculated as NFR-score = log2(nf) - log2((n1+n2)/2). 
A plot can be generate with the NFR scores as Y-axis and the average signals of 400 bp window as X-axis,
very like a MA plot for gene expression data.
}
\examples{
 
library(GenomicRanges)
bamfile <- system.file("extdata", "GL1.bam", 
                       package="ATACseqQC", mustWork=TRUE)
gal1 <- readBamFile(bamFile=bamfile, tag=character(0), 
                    which=GRanges("chr1", IRanges(1, 1e6)), 
                    asMates=FALSE)
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
txs <- transcripts(TxDb.Hsapiens.UCSC.hg19.knownGene)
nfr <- NFRscore(gal1, txs)
}
\author{
Jianhong Ou
}
